// SoX Resampler Library wrapper
// license for soxr: LGPL v2.1, see soxr-master/COPYING.LGPL

#include "soxr_wrapper.h"
#include <soxr.h>

void *__cdecl soxrw_create(unsigned p_in_samplerate, unsigned p_out_samplerate, unsigned p_channels, unsigned p_recipe, unsigned p_precision, unsigned p_bandwidth, unsigned p_flags, double p_stopband_begin, double p_phase, const char **p_error)
{
    soxr_quality_spec_t ql_spec;
    soxr_runtime_spec_t rt_spec;
    soxr_io_spec_t io_spec;
    soxr_t m_soxr;

    ql_spec = soxr_quality_spec(p_recipe, p_flags, p_precision, p_bandwidth);

    if (p_stopband_begin >= 0) ql_spec.stopband_begin = p_stopband_begin;
    ql_spec.phase_response = p_phase;

    rt_spec = soxr_runtime_spec(1);

    #ifdef _M_IX86
    const soxr_datatype_t sample_type = SOXR_FLOAT32_I;
    #else
    const soxr_datatype_t sample_type = SOXR_FLOAT64_I;
    #endif
    io_spec = soxr_io_spec(sample_type, sample_type);
    io_spec.flags = SOXR_NO_DITHER;

    m_soxr = soxr_create(p_in_samplerate, p_out_samplerate, p_channels, p_error, &io_spec, &ql_spec, &rt_spec);
    return (void *)m_soxr;
}

void __cdecl soxrw_delete(void *p_soxr) { soxr_delete((soxr_t)p_soxr); }
const char *__cdecl soxrw_clear(void *p_soxr) { return soxr_clear((soxr_t)p_soxr); }
const char *__cdecl soxrw_process(void *p_soxr, const void *p_in, size_t ilen, size_t *isize, void *p_out, size_t olen, size_t *osize) { return soxr_process((soxr_t)p_soxr, (soxr_in_t *)p_in, ilen, isize, (soxr_out_t *)p_out, olen, osize); }
const char *__cdecl soxrw_get_version() { return SOXR_THIS_VERSION_STR; }
